/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class GaddockTeegReplacementEffect4
extends ContinuousRuleModifyingEffectImpl {
    public GaddockTeegReplacementEffect4() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Noncreature spells with mana value 4 or greater can't be cast";
    }

    private GaddockTeegReplacementEffect4(GaddockTeegReplacementEffect4 effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public GaddockTeegReplacementEffect4 copy() {
        return new GaddockTeegReplacementEffect4(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        return card != null && !card.isCreature(game) && card.getManaValue() >= 4;
    }
}

