/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Set;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GahijiHonoredOneTriggeredAbility
extends TriggeredAbilityImpl {
    public GahijiHonoredOneTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostTargetEffect(2, 0, Duration.EndOfTurn), false);
    }

    public GahijiHonoredOneTriggeredAbility(Effect effect, boolean optional, String text) {
        super(Zone.BATTLEFIELD, effect, optional);
    }

    private GahijiHonoredOneTriggeredAbility(GahijiHonoredOneTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Set opponents;
        Permanent planeswalker;
        Player defender = game.getPlayer(event.getTargetId());
        if (defender == null && (planeswalker = game.getPermanent(event.getTargetId())) != null) {
            defender = game.getPlayer(planeswalker.getControllerId());
        }
        if (defender != null && (opponents = game.getOpponents(this.getControllerId())) != null && opponents.contains(defender.getId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature attacks one of your opponents or a planeswalker an opponent controls, that creature gets +2/+0 until end of turn.";
    }

    public GahijiHonoredOneTriggeredAbility copy() {
        return new GahijiHonoredOneTriggeredAbility(this);
    }
}

