/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PhaseOutAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GaladrielsDismissalPhaseOutTargetPlayerEffect
extends OneShotEffect {
    GaladrielsDismissalPhaseOutTargetPlayerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each creature target player controls phases out. <i>(Treat phased-out creatures and anything attached to them as though they don't exist until their controller's next turn.)</i>";
    }

    private GaladrielsDismissalPhaseOutTargetPlayerEffect(GaladrielsDismissalPhaseOutTargetPlayerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GaladrielsDismissalPhaseOutTargetPlayerEffect copy() {
        return new GaladrielsDismissalPhaseOutTargetPlayerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            ArrayList<UUID> permIds = new ArrayList<UUID>();
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURES, player.getId(), game)) {
                permIds.add(permanent.getId());
            }
            return new PhaseOutAllEffect(permIds).apply(game, source);
        }
        return false;
    }
}

