/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.constants.CardType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetadjustment.TargetAdjuster;
import mage.target.targetpointer.FirstTargetPointer;
import mage.target.targetpointer.TargetPointer;

enum GaleWaterdeepProdigyAdjuster implements TargetAdjuster
{
    instance;

    private static final FilterCard SORCERY_FILTER;
    private static final FilterCard INSTANT_FILTER;

    public void adjustTargets(Ability ability, Game game) {
        UUID spellId = ((Effect)ability.getEffects().get(0)).getTargetPointer().getFirst(game, ability);
        ability.getTargets().clear();
        ability.getAllEffects().setTargetPointer((TargetPointer)new FirstTargetPointer());
        Spell spell = game.getSpellOrLKIStack(spellId);
        if (spell == null) {
            return;
        }
        FilterCard filter = spell.isSorcery(game) ? INSTANT_FILTER : SORCERY_FILTER;
        ability.addTarget((Target)new TargetCardInYourGraveyard(0, 1, filter));
    }

    static {
        SORCERY_FILTER = new FilterCard("a sorcery card in your graveyard");
        INSTANT_FILTER = new FilterCard("an instant card in your graveyard");
        SORCERY_FILTER.add((Predicate)CardType.SORCERY.getPredicate());
        INSTANT_FILTER.add((Predicate)CardType.INSTANT.getPredicate());
    }
}

