/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.InfoEffect;
import mage.abilities.effects.common.RollDieWithResultTableEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class GalesRedirectionEffect
extends RollDieWithResultTableEffect {
    GalesRedirectionEffect() {
        super(20, "exile target spell, then roll a d20 and add that spell's mana value");
        this.addTableEntry(1, 14, new Effect[]{new InfoEffect("you may cast the exiled card for as long as it remains exiled, and you may spend mana as though it were mana of any color to cast that spell")});
        this.addTableEntry(15, Integer.MAX_VALUE, new Effect[]{new InfoEffect("you may cast the exiled card without paying its mana cost for as long as it remains exiled")});
    }

    private GalesRedirectionEffect(GalesRedirectionEffect effect) {
        super((RollDieWithResultTableEffect)effect);
    }

    public GalesRedirectionEffect copy() {
        return new GalesRedirectionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Spell spell = game.getSpell(this.getTargetPointer().getFirst(game, source));
        if (player == null || spell == null) {
            return false;
        }
        int manaValue = spell.getManaValue();
        player.moveCards((Card)spell, Zone.EXILED, source, game);
        int result = player.rollDice(this.outcome, source, game, 20) + manaValue;
        Card card = spell.getMainCard();
        if (card == null || !Zone.EXILED.match(game.getState().getZone(card.getId()))) {
            return true;
        }
        if (result >= 15) {
            game.addEffect(new PlayFromNotOwnHandZoneTargetEffect(Zone.EXILED, TargetController.YOU, Duration.Custom, true, true).setTargetPointer((TargetPointer)new FixedTarget(card, game)), source);
        } else if (result >= 1) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)true, (Duration)Duration.Custom, (boolean)true);
        }
        return true;
    }
}

