/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GameOfChaosEffect
extends OneShotEffect {
    GameOfChaosEffect() {
        super(Outcome.Detriment);
        this.staticText = "Flip a coin. If you win the flip, you gain 1 life and target opponent loses 1 life, and you decide whether to flip again. If you lose the flip, you lose 1 life and that opponent gains 1 life, and that player decides whether to flip again. Double the life stakes with each flip.";
    }

    private GameOfChaosEffect(GameOfChaosEffect effect) {
        super((OneShotEffect)effect);
    }

    public GameOfChaosEffect copy() {
        return new GameOfChaosEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player you = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (you != null && targetOpponent != null) {
            boolean continueFlipping = true;
            boolean youWonFlip = you.flipCoin(source, game, true);
            boolean youWonLastFlip = false;
            int lifeAmount = 1;
            while (continueFlipping) {
                if (youWonFlip) {
                    this.handleLifeChangesFromFlip(game, you, targetOpponent, lifeAmount, source);
                    if (!this.cannotContinueFlipping(you, targetOpponent)) {
                        continueFlipping = you.chooseUse(this.outcome, "You gained " + lifeAmount + " life! Flip again for double the life stakes?", source, game);
                        youWonLastFlip = true;
                    }
                } else {
                    this.handleLifeChangesFromFlip(game, targetOpponent, you, lifeAmount, source);
                    if (!this.cannotContinueFlipping(you, targetOpponent)) {
                        continueFlipping = targetOpponent.chooseUse(this.outcome, "You gained " + lifeAmount + " life! Flip again for double the life stakes?", source, game);
                        youWonLastFlip = false;
                    }
                }
                if (this.cannotContinueFlipping(you, targetOpponent)) {
                    continueFlipping = false;
                }
                if (!continueFlipping) continue;
                lifeAmount *= 2;
                youWonFlip = youWonLastFlip ? you.flipCoin(source, game, true) : !targetOpponent.flipCoin(source, game, true);
            }
            return true;
        }
        return false;
    }

    private void handleLifeChangesFromFlip(Game game, Player playerGainingLife, Player playerLosingLife, int lifeAmount, Ability source) {
        playerGainingLife.gainLife(lifeAmount, game, source);
        playerLosingLife.loseLife(lifeAmount, game, source, false);
    }

    private boolean cannotContinueFlipping(Player you, Player opponent) {
        return !you.canRespond() || !opponent.canRespond() || you.canLoseByZeroOrLessLife() && you.getLife() <= 0 || opponent.canLoseByZeroOrLessLife() && opponent.getLife() <= 0;
    }
}

