/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.events.NumberOfTriggersEvent;
import mage.game.events.ZoneChangeEvent;

class GandalfTheWhiteDoublingEffect
extends ReplacementEffectImpl {
    GandalfTheWhiteDoublingEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a legendary permanent or an artifact entering or leaving the battlefield causes a triggered ability of a permanent you control to trigger, that ability triggers an additional time.";
    }

    private GandalfTheWhiteDoublingEffect(GandalfTheWhiteDoublingEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GandalfTheWhiteDoublingEffect copy() {
        return new GandalfTheWhiteDoublingEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.NUMBER_OF_TRIGGERS;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        NumberOfTriggersEvent numberOfTriggersEvent = (NumberOfTriggersEvent)event;
        if (source.isControlledBy(event.getPlayerId())) {
            ZoneChangeEvent zEvent;
            EntersTheBattlefieldEvent entersTheBattlefieldEvent;
            GameEvent sourceEvent = numberOfTriggersEvent.getSourceEvent();
            if (sourceEvent != null && sourceEvent.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && sourceEvent instanceof EntersTheBattlefieldEvent && ((entersTheBattlefieldEvent = (EntersTheBattlefieldEvent)sourceEvent).getTarget().isArtifact(game) || entersTheBattlefieldEvent.getTarget().isLegendary(game))) {
                return game.getPermanent(numberOfTriggersEvent.getSourceId()) != null;
            }
            if (sourceEvent != null && sourceEvent.getType() == GameEvent.EventType.ZONE_CHANGE && sourceEvent instanceof ZoneChangeEvent && (zEvent = (ZoneChangeEvent)sourceEvent).getFromZone() == Zone.BATTLEFIELD && zEvent.getToZone() != Zone.BATTLEFIELD && (zEvent.getTarget().isLegendary(game) || zEvent.getTarget().isArtifact(game))) {
                return game.getPermanentOrLKIBattlefield(numberOfTriggersEvent.getSourceId()) != null;
            }
        }
        return false;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(event.getAmount() + 1);
        return false;
    }
}

