/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class GarbageElementalDEffect
extends OneShotEffect {
    GarbageElementalDEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a six-sided die. {this} deals damage equal to the result to target opponent";
    }

    private GarbageElementalDEffect(GarbageElementalDEffect effect) {
        super((OneShotEffect)effect);
    }

    public GarbageElementalDEffect copy() {
        return new GarbageElementalDEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(source.getFirstTarget());
        if (controller != null && opponent != null) {
            int damage = controller.rollDice(this.outcome, source, game, 6);
            return game.damagePlayerOrPermanent(opponent.getId(), damage, source.getId(), source, game, false, true) > 0;
        }
        return false;
    }
}

