/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GarrukSavageHeraldEffect
extends OneShotEffect {
    GarrukSavageHeraldEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. If it's a creature card, put it into your hand. Otherwise, put it on the bottom of your library";
    }

    private GarrukSavageHeraldEffect(GarrukSavageHeraldEffect effect) {
        super((OneShotEffect)effect);
    }

    public GarrukSavageHeraldEffect copy() {
        return new GarrukSavageHeraldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards(source, (Cards)new CardsImpl(card), game);
        if (card.isCreature(game)) {
            return player.moveCards(card, Zone.HAND, source, game);
        }
        return player.putCardsOnBottomOfLibrary(card, game, source);
    }
}

