/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.costs.common.ExileFromHandCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.EntersBattlefieldEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class GemstoneCavernsEffect
extends OneShotEffect {
    GemstoneCavernsEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may begin the game with {this} on the battlefield with a luck counter on it. If you do, exile a card from your hand";
    }

    private GemstoneCavernsEffect(GemstoneCavernsEffect effect) {
        super((OneShotEffect)effect);
    }

    public GemstoneCavernsEffect copy() {
        return new GemstoneCavernsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        boolean result = false;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null && (card = game.getCard(source.getSourceId())) != null) {
            ExileFromHandCost cost;
            Permanent permanent;
            EntersBattlefieldEffect effect = new EntersBattlefieldEffect((Effect)new AddCountersSourceEffect(CounterType.LUCK.createInstance()), "");
            effect.setDuration(Duration.OneUse);
            game.addEffect((ContinuousEffect)effect, source);
            if (controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = game.getPermanent(card.getId())) != null && (cost = new ExileFromHandCost(new TargetCardInHand())).canPay(source, source, source.getControllerId(), game)) {
                result = cost.pay(source, game, source, source.getControllerId(), true, null);
            }
        }
        return result;
    }
}

