/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.keyword.HasteAbility;
import mage.cards.g.GeneratorServantWatcher;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GeneratorServantHasteEffect
extends ContinuousEffectImpl {
    GeneratorServantHasteEffect() {
        super(Duration.EndOfGame, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.AddAbility);
    }

    private GeneratorServantHasteEffect(GeneratorServantHasteEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GeneratorServantHasteEffect copy() {
        return new GeneratorServantHasteEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        GeneratorServantWatcher watcher = (GeneratorServantWatcher)game.getState().getWatcher(GeneratorServantWatcher.class, source.getSourceId());
        if (watcher == null) {
            return false;
        }
        for (Permanent perm : game.getBattlefield().getAllActivePermanents()) {
            if (!watcher.creatureCastWithServantsMana(perm.getId())) continue;
            perm.addAbility((Ability)HasteAbility.getInstance(), source.getSourceId(), game);
        }
        return true;
    }
}

