/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterPermanentCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.util.CardUtil;

class GenesisHydraPutOntoBattlefieldEffect
extends OneShotEffect {
    GenesisHydraPutOntoBattlefieldEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "reveal the top X cards of your library. You may put a nonland permanent card with mana value X or less from among them onto the battlefield. Then shuffle the rest into your library";
    }

    private GenesisHydraPutOntoBattlefieldEffect(GenesisHydraPutOntoBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Object obj = this.getValue("sourceCastSpellAbility");
        if (controller != null && obj instanceof SpellAbility) {
            int count = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)((SpellAbility)obj), (String)"X", (Object)0);
            if (count > 0) {
                CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, count));
                controller.revealCards(source, (Cards)cards, game);
                FilterPermanentCard filter = new FilterPermanentCard("a nonland permanent card with mana value " + count + " or less to put onto the battlefield");
                filter.add(Predicates.not((Predicate)CardType.LAND.getPredicate()));
                filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, count + 1));
                TargetCard target1 = new TargetCard(0, 1, Zone.LIBRARY, (FilterCard)filter);
                if (cards.count((FilterCard)filter, source.getSourceId(), source, game) > 0) {
                    if (controller.choose(Outcome.PutCardInPlay, (Cards)cards, target1, source, game)) {
                        Card card = cards.get(target1.getFirstTarget(), game);
                        if (card != null) {
                            cards.remove(card);
                            controller.moveCards(card, Zone.BATTLEFIELD, source, game);
                        }
                        target1.clearChosen();
                    } else {
                        game.informPlayers(controller.getLogName() + " didn't choose anything");
                    }
                } else {
                    game.informPlayers("No nonland permanent card with mana value " + count + " or less to choose.");
                }
                if (!cards.isEmpty()) {
                    controller.moveCards((Cards)cards, Zone.LIBRARY, source, game);
                    controller.shuffleLibrary(source, game);
                }
            }
            return true;
        }
        return false;
    }

    public GenesisHydraPutOntoBattlefieldEffect copy() {
        return new GenesisHydraPutOntoBattlefieldEffect(this);
    }
}

