/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Optional;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.common.DestroyAllEffect;
import mage.cards.g.GenesisOfTheDaleksWatcher;
import mage.choices.VillainousChoice;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.players.Player;

class GenesisOfTheDaleksFirstChoice
extends VillainousChoice {
    private static final FilterPermanent filter = new FilterCreaturePermanent(SubType.DALEK, "");

    GenesisOfTheDaleksFirstChoice() {
        super("Destroy all Dalek creatures and each of your opponents loses life equal to the total power of Daleks that died this turn", "Destroy all Daleks and lose life");
    }

    public boolean doChoice(Player player, Game game, Ability source) {
        new DestroyAllEffect(filter).apply(game, source);
        game.processAction();
        int amount = ((GenesisOfTheDaleksWatcher)game.getState().getWatcher(GenesisOfTheDaleksWatcher.class)).getPower();
        if (amount > 0) {
            for (UUID opponentId : game.getOpponents(source.getControllerId())) {
                Optional.ofNullable(opponentId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(opponent -> opponent.loseLife(amount, game, source, false));
            }
        }
        return true;
    }
}

