/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

class GenesisOfTheDaleksWatcher
extends Watcher {
    private int power = 0;

    GenesisOfTheDaleksWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget().hasSubtype(SubType.DALEK, game)) {
            this.power += zEvent.getTarget().getPower().getValue();
        }
    }

    public void reset() {
        super.reset();
        this.power = 0;
    }

    public int getPower() {
        return this.power;
    }
}

