/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GenesisStormEffect
extends OneShotEffect {
    GenesisStormEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "reveal cards from the top of your library until you reveal a nonland permanent card. You may put that card onto the battlefield. Then put all cards revealed this way that weren't put onto the battlefield on the bottom of your library in a random order";
    }

    private GenesisStormEffect(GenesisStormEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl toReveal = new CardsImpl();
        Card nonLandCard = null;
        for (Card card : controller.getLibrary().getCards(game)) {
            toReveal.add(card);
            if (!card.isPermanent(game) || card.isLand(game)) continue;
            nonLandCard = card;
            break;
        }
        controller.revealCards(source, (Cards)toReveal, game);
        if (nonLandCard != null && controller.chooseUse(this.outcome, "Put " + nonLandCard.getLogName() + " onto the battlefield?", source, game)) {
            controller.moveCards(nonLandCard, Zone.BATTLEFIELD, source, game);
            toReveal.remove(nonLandCard);
        }
        controller.putCardsOnBottomOfLibrary((Cards)toReveal, game, source, false);
        return true;
    }

    public GenesisStormEffect copy() {
        return new GenesisStormEffect(this);
    }
}

