/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GethLordOfTheVaultEffect
extends OneShotEffect {
    GethLordOfTheVaultEffect() {
        super(Outcome.Benefit);
        this.staticText = "Put target artifact or creature card with mana value X from an opponent's graveyard onto the battlefield under your control tapped. Then that player mills X cards";
    }

    private GethLordOfTheVaultEffect(GethLordOfTheVaultEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Card card = game.getCard(this.getTargetPointer().getFirst(game, source));
        if (card == null) {
            return true;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
        Player player = game.getPlayer(card.getOwnerId());
        if (player != null) {
            player.millCards(card.getManaValue(), source, game);
        }
        return true;
    }

    public GethLordOfTheVaultEffect copy() {
        return new GethLordOfTheVaultEffect(this);
    }
}

