/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.CardType;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.card.OwnerIdPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInOpponentsGraveyard;
import mage.target.common.TargetCardInYourGraveyard;
import mage.target.targetadjustment.TargetAdjuster;

enum GethsSummonsAdjuster implements TargetAdjuster
{
    instance;


    public void adjustTargets(Ability ability, Game game) {
        ability.getTargets().clear();
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(0, 1, (FilterCard)StaticFilters.FILTER_CARD_CREATURE_YOUR_GRAVEYARD);
        ability.addTarget((Target)target);
        for (UUID opponentId : game.getOpponents(ability.getControllerId(), true)) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || opponent.getCountersCount(CounterType.POISON) < 3) continue;
            FilterCard filter = new FilterCard("creature card from " + opponent.getLogName() + "'s graveyard");
            filter.add((Predicate)new OwnerIdPredicate(opponentId));
            filter.add((Predicate)CardType.CREATURE.getPredicate());
            target = new TargetCardInOpponentsGraveyard(0, 1, filter);
            ability.addTarget((Target)target);
        }
    }
}

