/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.AbilityWord;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInOpponentsGraveyard;
import mage.target.common.TargetCardInYourGraveyard;

class GethsSummonsEffect
extends OneShotEffect {
    GethsSummonsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return up to one target creature card from your graveyard to the battlefield.<br>" + AbilityWord.CORRUPTED.formatWord() + "For each opponent who has three or more poison counters as you cast this spell, put up to one target creature card from that player's graveyard onto the battlefield under your control";
    }

    private GethsSummonsEffect(GethsSummonsEffect effect) {
        super((OneShotEffect)effect);
    }

    public GethsSummonsEffect copy() {
        return new GethsSummonsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        HashSet<Card> cardsToBattlefield = new HashSet<Card>();
        for (Target target : source.getTargets()) {
            Card targetCard;
            if (!(target instanceof TargetCardInYourGraveyard) && !(target instanceof TargetCardInOpponentsGraveyard) || (targetCard = game.getCard(target.getFirstTarget())) == null) continue;
            cardsToBattlefield.add(targetCard);
        }
        if (!cardsToBattlefield.isEmpty()) {
            controller.moveCards(cardsToBattlefield, Zone.BATTLEFIELD, source, game);
            return true;
        }
        return false;
    }
}

