/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CardType;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class GhaltaPrimalHungerCostReductionEffect
extends CostModificationEffectImpl {
    private static final FilterPermanent filter = new FilterControlledArtifactPermanent("noncreature artifacts you control");

    GhaltaPrimalHungerCostReductionEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "this spell costs {X} less to cast, where X is the total power of creatures you control";
    }

    private GhaltaPrimalHungerCostReductionEffect(GhaltaPrimalHungerCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        int totalPower = 0;
        for (Permanent permanent : game.getBattlefield().getAllActivePermanents(source.getControllerId())) {
            if (!permanent.isCreature(game)) continue;
            totalPower += permanent.getPower().getValue();
        }
        CardUtil.reduceCost((Ability)abilityToModify, (int)totalPower);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.getSourceId().equals(source.getSourceId()) && abilityToModify instanceof SpellAbility;
    }

    public GhaltaPrimalHungerCostReductionEffect copy() {
        return new GhaltaPrimalHungerCostReductionEffect(this);
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
    }
}

