/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GhastlyDeathTyrantEffect
extends OneShotEffect {
    GhastlyDeathTyrantEffect() {
        super(Outcome.Benefit);
        this.staticText = "destroy target enchantment an opponent controls. You lose life equal to its mana value";
    }

    private GhastlyDeathTyrantEffect(GhastlyDeathTyrantEffect effect) {
        super((OneShotEffect)effect);
    }

    public GhastlyDeathTyrantEffect copy() {
        return new GhastlyDeathTyrantEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        permanent.destroy(source, game);
        player.loseLife(permanent.getManaValue(), game, source, false);
        return true;
    }
}

