/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GhostflameSliverEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent(SubType.SLIVER, "All Slivers");

    public GhostflameSliverEffect() {
        super(Duration.WhileOnBattlefield, Layer.ColorChangingEffects_5, SubLayer.NA, Outcome.Benefit);
        this.staticText = "All Slivers are colorless";
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (!filter.match((Object)perm, game)) continue;
            perm.getColor(game).setColor(ObjectColor.COLORLESS);
        }
        return true;
    }

    public GhostflameSliverEffect copy() {
        return new GhostflameSliverEffect(this);
    }

    private GhostflameSliverEffect(GhostflameSliverEffect effect) {
        super((ContinuousEffectImpl)effect);
    }
}

