/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class GhostlyDancersEffect
extends OneShotEffect {
    GhostlyDancersEffect() {
        super(Outcome.Benefit);
        this.staticText = "return an enchantment card from your graveyard to your hand or unlock a locked door of a Room you control";
    }

    private GhostlyDancersEffect(GhostlyDancersEffect effect) {
        super((OneShotEffect)effect);
    }

    public GhostlyDancersEffect copy() {
        return new GhostlyDancersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count(StaticFilters.FILTER_CARD_ENCHANTMENT, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(StaticFilters.FILTER_CARD_ENCHANTMENT);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.HAND, source, game);
    }
}

