/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GhoulsNightOutTypeChangingEffect
extends ContinuousEffectImpl {
    GhoulsNightOutTypeChangingEffect() {
        super(Duration.Custom, Outcome.Neutral);
    }

    private GhoulsNightOutTypeChangingEffect(GhoulsNightOutTypeChangingEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GhoulsNightOutTypeChangingEffect copy() {
        return new GhoulsNightOutTypeChangingEffect(this);
    }

    public boolean apply(Layer layer, SubLayer subLayer, Ability source, Game game) {
        boolean isActive = false;
        for (UUID permId : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent(permId);
            if (permanent == null) continue;
            switch (layer) {
                case ColorChangingEffects_5: {
                    permanent.getColor(game).setBlack(true);
                    isActive = true;
                    break;
                }
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.ZOMBIE});
                    isActive = true;
                }
            }
        }
        return isActive;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.ColorChangingEffects_5 || layer == Layer.TypeChangingEffects_4;
    }
}

