/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.List;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GiantAlbatrossEffect
extends OneShotEffect {
    GiantAlbatrossEffect() {
        super(Outcome.Detriment);
        this.staticText = "for each creature that dealt damage to {this} this turn, destroy that creature unless its controller pays 2 life. A creature destroyed this way can't be regenerated";
    }

    private GiantAlbatrossEffect(GiantAlbatrossEffect effect) {
        super((OneShotEffect)effect);
    }

    public GiantAlbatrossEffect copy() {
        return new GiantAlbatrossEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourcePermanent != null && controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null) continue;
                List creatures = game.getBattlefield().getAllActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, playerId, game);
                PayLifeCost cost = new PayLifeCost(2);
                for (Permanent creature : creatures) {
                    if (!sourcePermanent.getDealtDamageByThisTurn().contains(new MageObjectReference(creature.getId(), game))) continue;
                    StringBuilder sb = new StringBuilder("Pay 2 life? (Otherwise ").append(creature.getName()).append(" will be destroyed)");
                    if (cost.canPay(source, source, creature.getControllerId(), game) && player.chooseUse(Outcome.Benefit, sb.toString(), source, game)) {
                        cost.pay(source, game, source, creature.getControllerId(), true, null);
                    }
                    if (cost.isPaid()) continue;
                    creature.destroy(source, game, true);
                }
            }
        }
        return false;
    }
}

