/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.TapTargetEffect;
import mage.cards.AdventureCard;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreaturePermanent;

public final class GiantKiller
extends AdventureCard {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creature with power 4 or greater");

    public GiantKiller(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, new CardType[]{CardType.INSTANT}, "{W}", "Chop Down", "{2}{W}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.PEASANT);
        this.power = new MageInt(1);
        this.toughness = new MageInt(2);
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new TapTargetEffect(), (Cost)new ManaCostsImpl("{1}{W}"));
        ability.addCost((Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetCreaturePermanent());
        this.addAbility((Ability)ability);
        this.getSpellCard().getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellCard().getSpellAbility().addTarget((Target)new TargetPermanent(filter));
        this.finalizeAdventure();
    }

    private GiantKiller(GiantKiller card) {
        super((AdventureCard)card);
    }

    public GiantKiller copy() {
        return new GiantKiller(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.MORE_THAN, 3));
    }
}

