/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.g.GideonTheOathswornEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class GideonTheOathswornTriggeredAbility
extends TriggeredAbilityImpl {
    GideonTheOathswornTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
    }

    private GideonTheOathswornTriggeredAbility(GideonTheOathswornTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public GideonTheOathswornTriggeredAbility copy() {
        return new GideonTheOathswornTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getCombat().getAttackingPlayerId().equals(this.getControllerId())) {
            int attackerCount = 0;
            HashSet<MageObjectReference> attackers = new HashSet<MageObjectReference>();
            for (UUID attackerId : game.getCombat().getAttackers()) {
                Permanent permanent = game.getPermanent(attackerId);
                if (permanent == null || !permanent.isCreature(game) || permanent.hasSubtype(SubType.GIDEON, game)) continue;
                ++attackerCount;
                attackers.add(new MageObjectReference((MageObject)permanent, game));
            }
            if (attackerCount >= 2) {
                this.getEffects().clear();
                this.addEffect((Effect)new GideonTheOathswornEffect(attackers));
                return true;
            }
        }
        return false;
    }

    public String getRule() {
        return "Whenever you attack with two or more non-Gideon creatures, put a +1/+1 counter on each of those creatures.";
    }
}

