/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

class GideonsInterventionCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    GideonsInterventionCantCastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Your opponents can't cast spells with the chosen name";
    }

    private GideonsInterventionCantCastEffect(GideonsInterventionCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public GideonsInterventionCantCastEffect copy() {
        return new GideonsInterventionCantCastEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (mageObject != null && cardName != null) {
            return "You can't cast a card named " + cardName + " (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE || event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (game.getOpponents(source.getControllerId()).contains(event.getPlayerId())) {
            SpellAbility spellAbility = SpellAbility.getSpellAbilityFromEvent((GameEvent)event, (Game)game);
            if (spellAbility == null) {
                return false;
            }
            Card card = spellAbility.getCharacteristics(game);
            return card != null && CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game);
        }
        return false;
    }
}

