/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.SacrificeEffect;
import mage.cards.g.GideonsTriumphPredicate;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPlaneswalkerPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;

class GideonsTriumphEffect
extends OneShotEffect {
    private static final FilterControlledPlaneswalkerPermanent filterGideon = new FilterControlledPlaneswalkerPermanent(SubType.GIDEON);
    private static final FilterPermanent filterSacrifice = new FilterPermanent("creature that attacked or blocked this turn");

    GideonsTriumphEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent sacrifices a creature that attacked or blocked this turn. If you control a Gideon planeswalker, that player sacrifices two of those creatures instead.";
    }

    private GideonsTriumphEffect(GideonsTriumphEffect effect) {
        super((OneShotEffect)effect);
    }

    public GideonsTriumphEffect copy() {
        return new GideonsTriumphEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int count = 1;
        if (!game.getBattlefield().getActivePermanents((FilterPermanent)filterGideon, source.getControllerId(), game).isEmpty()) {
            ++count;
        }
        return new SacrificeEffect(filterSacrifice, count, "Target opponent").apply(game, source);
    }

    static {
        filterSacrifice.add((Predicate)GideonsTriumphPredicate.instance);
    }
}

