/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GiftOfFangsEffect
extends ContinuousEffectImpl {
    GiftOfFangsEffect() {
        super(Duration.WhileOnBattlefield, Layer.PTChangingEffects_7, SubLayer.ModifyPT_7c, Outcome.Neutral);
        this.staticText = "Enchanted creature gets +2/+2 as long as it's a Vampire. Otherwise, it gets -2/-2";
    }

    private GiftOfFangsEffect(GiftOfFangsEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GiftOfFangsEffect copy() {
        return new GiftOfFangsEffect(this);
    }

    public void init(Ability source, Game game) {
        Permanent equipment;
        if (this.getAffectedObjectsSetAtInit(source) && (equipment = game.getPermanentOrLKIBattlefield(source.getSourceId())) != null && equipment.getAttachedTo() != null) {
            this.setTargetPointer((TargetPointer)new FixedTarget(equipment.getAttachedTo(), game.getState().getZoneChangeCounter(equipment.getAttachedTo())));
        }
        super.init(source, game);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = null;
        if (this.getAffectedObjectsSet()) {
            permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (permanent == null) {
                this.discard();
                return true;
            }
        } else {
            Permanent equipment = game.getPermanent(source.getSourceId());
            if (equipment != null && equipment.getAttachedTo() != null) {
                permanent = game.getPermanent(equipment.getAttachedTo());
            }
        }
        if (permanent != null) {
            if (permanent.hasSubtype(SubType.VAMPIRE, game)) {
                permanent.addPower(2);
                permanent.addToughness(2);
            } else {
                permanent.addPower(-2);
                permanent.addToughness(-2);
            }
        }
        return true;
    }
}

