/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardAndOrCardInLibrary;

class GiftOfTheGargantuanEffect
extends OneShotEffect {
    GiftOfTheGargantuanEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Look at the top four cards of your library. You may reveal a creature card and/or a land card from among them and put the revealed cards into your hand. Put the rest on the bottom of your library in any order";
    }

    private GiftOfTheGargantuanEffect(GiftOfTheGargantuanEffect effect) {
        super((OneShotEffect)effect);
    }

    public GiftOfTheGargantuanEffect copy() {
        return new GiftOfTheGargantuanEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 4));
        TargetCardAndOrCardInLibrary target = new TargetCardAndOrCardInLibrary(CardType.CREATURE, CardType.LAND);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        CardsImpl toHand = new CardsImpl();
        toHand.addAll((Collection)target.getTargets());
        player.revealCards(source, (Cards)toHand, game);
        player.moveCards((Cards)toHand, Zone.HAND, source, game);
        cards.removeAll((Collection)toHand);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, true);
        return true;
    }
}

