/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.target.common.TargetCardWithDifferentNameInLibrary;

class GiftsUngivenEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("cards with different names");
    private static final FilterCard filter2 = new FilterCard("cards to put in graveyard");

    public GiftsUngivenEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Search your library for up to four cards with different names and reveal them. Target opponent chooses two of those cards. Put the chosen cards into your graveyard and the rest into your hand. Then shuffle";
    }

    private GiftsUngivenEffect(GiftsUngivenEffect effect) {
        super((OneShotEffect)effect);
    }

    public GiftsUngivenEffect copy() {
        return new GiftsUngivenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player == null || opponent == null) {
            return false;
        }
        TargetCardWithDifferentNameInLibrary target = new TargetCardWithDifferentNameInLibrary(0, 4, filter);
        player.searchLibrary((TargetCardInLibrary)target, source, game);
        CardsImpl cards = new CardsImpl((Collection)target.getTargets());
        cards.retainZone(Zone.LIBRARY, game);
        if (cards.isEmpty()) {
            player.shuffleLibrary(source, game);
        }
        player.revealCards(source, (Cards)cards, game);
        if (cards.size() > 2) {
            CardsImpl cardsToKeep = new CardsImpl();
            cardsToKeep.addAll((Collection)cards);
            TargetCard targetDiscard = new TargetCard(2, Zone.LIBRARY, filter2);
            if (opponent.choose(Outcome.Discard, (Cards)cards, targetDiscard, source, game)) {
                cardsToKeep.removeIf(targetDiscard.getTargets()::contains);
                cards.removeAll((Collection)cardsToKeep);
            }
            player.moveCards((Cards)cardsToKeep, Zone.HAND, source, game);
        }
        player.moveCards((Cards)cards, Zone.GRAVEYARD, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

