/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GilderBairnEffect
extends OneShotEffect {
    GilderBairnEffect() {
        super(Outcome.Benefit);
        this.staticText = "Double the number of each kind of counter on target permanent";
    }

    private GilderBairnEffect(GilderBairnEffect effect) {
        super((OneShotEffect)effect);
    }

    public GilderBairnEffect copy() {
        return new GilderBairnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target != null) {
            for (Counter counter : target.getCounters(game).values()) {
                Counter newCounter = new Counter(counter.getName(), counter.getCount());
                target.addCounters(newCounter, source.getControllerId(), source, game);
            }
        }
        return false;
    }
}

