/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GimlisFuryEffect
extends OneShotEffect {
    GimlisFuryEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's legendary, it also gains trample until end of turn";
    }

    private GimlisFuryEffect(GimlisFuryEffect effect) {
        super((OneShotEffect)effect);
    }

    public GimlisFuryEffect copy() {
        return new GimlisFuryEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null && permanent.isLegendary(game)) {
            game.addEffect(new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
            return true;
        }
        return false;
    }
}

