/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.DecayedAbility;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.ExileZone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class GisaGloriousResurrectorReturnEffect
extends OneShotEffect {
    GisaGloriousResurrectorReturnEffect() {
        super(Outcome.Benefit);
        this.staticText = "put all creature cards exiled with {this} onto the battlefield under your control. They gain decayed";
    }

    private GisaGloriousResurrectorReturnEffect(GisaGloriousResurrectorReturnEffect effect) {
        super((OneShotEffect)effect);
    }

    public GisaGloriousResurrectorReturnEffect copy() {
        return new GisaGloriousResurrectorReturnEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Ability exiledWithSource = (Ability)game.getState().getValue("GisaGloriousResurrectorExile" + source.getSourceId().toString() + game.getState().getZoneChangeCounter(source.getSourceId()));
        if (exiledWithSource == null) {
            return false;
        }
        ExileZone exileZone = game.getExile().getExileZone(CardUtil.getExileZoneId((Game)game, (Ability)exiledWithSource));
        if (player == null || exileZone == null || exileZone.isEmpty()) {
            return false;
        }
        CardsImpl cards = new CardsImpl(exileZone.getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game));
        if (cards.isEmpty()) {
            return false;
        }
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        cards.retainZone(Zone.BATTLEFIELD, game);
        if (cards.isEmpty()) {
            return false;
        }
        game.addEffect(new GainAbilityTargetEffect((Ability)new DecayedAbility(), Duration.Custom).setTargetPointer((TargetPointer)new FixedTargets((Cards)cards, game)), source);
        return true;
    }
}

