/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.util.CardUtil;

class GiselaBladeOfGoldnightDoubleDamageEffect
extends ReplacementEffectImpl {
    GiselaBladeOfGoldnightDoubleDamageEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Damage);
        this.staticText = "If a source would deal damage to an opponent or a permanent an opponent controls, that source deals double that damage to that player or permanent instead.";
    }

    private GiselaBladeOfGoldnightDoubleDamageEffect(GiselaBladeOfGoldnightDoubleDamageEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public GiselaBladeOfGoldnightDoubleDamageEffect copy() {
        return new GiselaBladeOfGoldnightDoubleDamageEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGE_PLAYER: 
            case DAMAGE_PERMANENT: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        return player.hasOpponent(event.getTargetId(), game) || player.hasOpponent(game.getControllerId(event.getTargetId()), game);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setAmount(CardUtil.overflowMultiply((int)event.getAmount(), (int)2));
        return false;
    }
}

