/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class GishathSunsAvatarEffect
extends OneShotEffect {
    GishathSunsAvatarEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal that many cards from the top of your library. Put any number of Dinosaur creature cards from among them onto the battlefield and the rest on the bottom of your library in a random order";
    }

    private GishathSunsAvatarEffect(GishathSunsAvatarEffect effect) {
        super((OneShotEffect)effect);
    }

    public GishathSunsAvatarEffect copy() {
        return new GishathSunsAvatarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int xValue = (Integer)this.getValue("damage");
        CardsImpl cards = new CardsImpl(controller.getLibrary().getTopCards(game, xValue));
        if (!cards.isEmpty()) {
            controller.revealCards(source, (Cards)cards, game);
            FilterCreatureCard filter = new FilterCreatureCard("Dinosaur creature cards");
            filter.add((Predicate)SubType.DINOSAUR.getPredicate());
            TargetCard target1 = new TargetCard(0, Integer.MAX_VALUE, Zone.LIBRARY, (FilterCard)filter);
            target1.withNotTarget(true);
            controller.choose(Outcome.PutCardInPlay, (Cards)cards, target1, source, game);
            CardsImpl toBattlefield = new CardsImpl((Collection)target1.getTargets());
            cards.removeAll((Collection)toBattlefield);
            controller.moveCards(toBattlefield.getCards(game), Zone.BATTLEFIELD, source, game, false, false, false, null);
            controller.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        }
        return true;
    }
}

