/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GlacialCrasherEffect
extends RestrictionEffect {
    private static final FilterLandPermanent filter = new FilterLandPermanent("Mountain");

    public GlacialCrasherEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless there is a Mountain on the battlefield";
    }

    private GlacialCrasherEffect(GlacialCrasherEffect effect) {
        super((RestrictionEffect)effect);
    }

    public GlacialCrasherEffect copy() {
        return new GlacialCrasherEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            return game.getBattlefield().count((FilterPermanent)filter, source.getControllerId(), source, game) < 1;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.MOUNTAIN.getPredicate());
    }
}

