/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

class GlacialDragonhuntEffect
extends OneShotEffect {
    GlacialDragonhuntEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may discard a card. When you discard a nonland card this way, {this} deals 3 damage to target creature";
    }

    private GlacialDragonhuntEffect(GlacialDragonhuntEffect effect) {
        super((OneShotEffect)effect);
    }

    public GlacialDragonhuntEffect copy() {
        return new GlacialDragonhuntEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty() || player.discard(0, 1, true, source, game).count((FilterCard)StaticFilters.FILTER_CARD_NON_LAND, game) < 1) {
            return false;
        }
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(3), false);
        ability.addTarget((Target)new TargetCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

