/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.Target;

class GlarecasterEffect
extends RedirectionEffect {
    protected MageObjectReference redirectToObject;

    public GlarecasterEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, RedirectionEffect.UsageType.ONE_USAGE_AT_THE_SAME_TIME);
        this.staticText = "The next time damage would be dealt to {this} and/or you this turn, that damage is dealt to any target instead";
    }

    private GlarecasterEffect(GlarecasterEffect effect) {
        super((RedirectionEffect)effect);
        this.redirectToObject = effect.redirectToObject;
    }

    public GlarecasterEffect copy() {
        return new GlarecasterEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.redirectToObject = new MageObjectReference(((Target)source.getTargets().get(0)).getFirstTarget(), game);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGE_PERMANENT || event.getType() == GameEvent.EventType.DAMAGE_PLAYER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if ((event.getTargetId().equals(source.getSourceId()) || event.getTargetId().equals(source.getControllerId())) && this.redirectToObject.equals((Object)new MageObjectReference(((Target)source.getTargets().get(0)).getFirstTarget(), game))) {
            this.redirectTarget = (Target)source.getTargets().get(0);
            return true;
        }
        return false;
    }
}

