/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.Duration;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class GlimpseOfNatureTriggeredAbility
extends DelayedTriggeredAbility {
    public GlimpseOfNatureTriggeredAbility() {
        super((Effect)new DrawCardSourceControllerEffect(1), Duration.EndOfTurn, false);
    }

    private GlimpseOfNatureTriggeredAbility(GlimpseOfNatureTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.SPELL_CAST;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell;
        return event.getPlayerId().equals(this.getControllerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null && StaticFilters.FILTER_SPELL_A_CREATURE.match((Object)spell, game);
    }

    public GlimpseOfNatureTriggeredAbility copy() {
        return new GlimpseOfNatureTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you cast a creature spell this turn, draw a card.";
    }
}

