/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.DiesSourceTriggeredAbility;
import mage.abilities.common.SimpleEvasionAbility;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.costs.common.ExileSourceFromGraveCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoWhenCostPaid;
import mage.abilities.effects.common.ReturnFromGraveyardToHandTargetEffect;
import mage.abilities.effects.common.combat.CantBeBlockedByCreaturesSourceEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.ToxicAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.g.GlissasRetrieverAdjuster;
import mage.constants.AbilityWord;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.PowerPredicate;
import mage.target.targetadjustment.TargetAdjuster;

public final class GlissasRetriever
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creatures with power 2 or less");

    public GlissasRetriever(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{5}{G}");
        this.subtype.add(new SubType[]{SubType.PHYREXIAN, SubType.BEAST});
        this.power = new MageInt(6);
        this.toughness = new MageInt(6);
        this.addAbility((Ability)HasteAbility.getInstance());
        this.addAbility((Ability)new ToxicAbility(3));
        this.addAbility((Ability)new SimpleEvasionAbility((Effect)new CantBeBlockedByCreaturesSourceEffect(filter, Duration.WhileOnBattlefield)));
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new ReturnFromGraveyardToHandTargetEffect().setText("return up to X target cards from your graveyard to your hand, where X is the number of opponents who have three or more poison counters"), false);
        ability.setTargetAdjuster((TargetAdjuster)GlissasRetrieverAdjuster.instance);
        this.addAbility((Ability)new DiesSourceTriggeredAbility((Effect)new DoWhenCostPaid(ability, new ExileSourceFromGraveCost().setText("exile it"), null, false)).setAbilityWord(AbilityWord.CORRUPTED));
    }

    private GlissasRetriever(GlissasRetriever card) {
        super((CardImpl)card);
    }

    public GlissasRetriever copy() {
        return new GlissasRetriever(this);
    }

    static {
        filter.add((Predicate)new PowerPredicate(ComparisonType.FEWER_THAN, 3));
    }
}

