/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SpiderToken;

class GloomwidowsFeastEffect
extends OneShotEffect {
    boolean applied = false;

    public GloomwidowsFeastEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature with flying. If that creature was blue or black, create a 1/2 green Spider creature token with reach";
    }

    private GloomwidowsFeastEffect(GloomwidowsFeastEffect effect) {
        super((OneShotEffect)effect);
    }

    public GloomwidowsFeastEffect copy() {
        return new GloomwidowsFeastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature != null) {
            targetCreature.destroy(source, game, false);
            Permanent destroyedCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            if (destroyedCreature.getColor(game).isBlue() || destroyedCreature.getColor(game).isBlack()) {
                SpiderToken token = new SpiderToken();
                token.putOntoBattlefield(1, game, source, source.getControllerId());
                return true;
            }
        }
        return false;
    }
}

