/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;
import mage.watchers.common.BlockedAttackerWatcher;

class GlyphOfDelusionSecondTarget
extends TargetPermanent {
    public GlyphOfDelusionSecondTarget() {
        this.withTargetName("target creature that target Wall blocked this turn");
    }

    private GlyphOfDelusionSecondTarget(GlyphOfDelusionSecondTarget target) {
        super((TargetPermanent)target);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        BlockedAttackerWatcher watcher = (BlockedAttackerWatcher)game.getState().getWatcher(BlockedAttackerWatcher.class);
        if (watcher == null) {
            return possibleTargets;
        }
        Permanent targetWall = game.getPermanent(source.getFirstTarget());
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
            if (targetWall == null) {
                possibleTargets.add(permanent.getId());
                continue;
            }
            if (!watcher.creatureHasBlockedAttacker(new MageObjectReference((MageObject)permanent, game), new MageObjectReference((MageObject)targetWall, game))) continue;
            possibleTargets.add(permanent.getId());
        }
        possibleTargets.removeIf(id -> targetWall != null && targetWall.getId().equals(id));
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public boolean chooseTarget(Outcome outcome, UUID playerId, Ability source, Game game) {
        return super.chooseTarget(Outcome.Tap, playerId, source, game);
    }

    public GlyphOfDelusionSecondTarget copy() {
        return new GlyphOfDelusionSecondTarget(this);
    }
}

