/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GoblinArchaeologistEffect
extends OneShotEffect {
    GoblinArchaeologistEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Flip a coin. If you win the flip, destroy target artifact and untap {this}. If you lose the flip, sacrifice {this}";
    }

    private GoblinArchaeologistEffect(GoblinArchaeologistEffect ability) {
        super((OneShotEffect)ability);
    }

    public GoblinArchaeologistEffect copy() {
        return new GoblinArchaeologistEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (player != null && permanent != null) {
            if (!player.flipCoin(source, game, true)) {
                permanent.sacrifice(source, game);
            } else {
                Permanent targetArtifact = game.getPermanent(source.getFirstTarget());
                targetArtifact.destroy(source, game, true);
                permanent.untap(game);
            }
            return true;
        }
        return false;
    }
}

