/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetSacrifice;

class GoblinAssassinTriggeredEffect
extends OneShotEffect {
    GoblinAssassinTriggeredEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "each player flips a coin. Each player whose coin comes up tails sacrifices a creature of their choice";
    }

    private GoblinAssassinTriggeredEffect(GoblinAssassinTriggeredEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList perms = new ArrayList();
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
                TargetSacrifice target;
                Player player = game.getPlayer(playerId);
                if (player == null || player.flipCoin(source, game, false) || !(target = new TargetSacrifice((FilterPermanent)StaticFilters.FILTER_PERMANENT_A_CREATURE)).canChoose(player.getId(), source, game)) continue;
                player.choose(Outcome.Sacrifice, (Target)target, source, game);
                perms.addAll(target.getTargets());
            }
            for (UUID permID : perms) {
                Permanent permanent = game.getPermanent(permID);
                if (permanent == null) continue;
                permanent.sacrifice(source, game);
            }
            return true;
        }
        return false;
    }

    public GoblinAssassinTriggeredEffect copy() {
        return new GoblinAssassinTriggeredEffect(this);
    }
}

