/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.watchers.common.PlayerCastCreatureWatcher;

class GoblinCohortEffect
extends RestrictionEffect {
    GoblinCohortEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack unless you've cast a creature spell this turn";
    }

    private GoblinCohortEffect(GoblinCohortEffect effect) {
        super((RestrictionEffect)effect);
    }

    public GoblinCohortEffect copy() {
        return new GoblinCohortEffect(this);
    }

    public boolean canAttack(Game game, boolean canUseChooseDialogs) {
        return false;
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        if (permanent.getId().equals(source.getSourceId())) {
            PlayerCastCreatureWatcher watcher = (PlayerCastCreatureWatcher)game.getState().getWatcher(PlayerCastCreatureWatcher.class);
            return watcher != null && !watcher.playerDidCastCreatureThisTurn(source.getControllerId());
        }
        return false;
    }
}

