/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.SearchEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class GoblinEngineerEffect
extends SearchEffect {
    GoblinEngineerEffect() {
        super(new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_ARTIFACT_AN), Outcome.Neutral);
        this.staticText = "search your library for an artifact card, put it into your graveyard, then shuffle";
    }

    private GoblinEngineerEffect(GoblinEngineerEffect effect) {
        super((SearchEffect)effect);
    }

    public GoblinEngineerEffect copy() {
        return new GoblinEngineerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (controller.searchLibrary(this.target, source, game)) {
            controller.moveCards(game.getCard(this.target.getFirstTarget()), Zone.GRAVEYARD, source, game);
        }
        controller.shuffleLibrary(source, game);
        return true;
    }
}

