/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GoblinFestivalGainControlEffect
extends ContinuousEffectImpl {
    UUID controller;

    public GoblinFestivalGainControlEffect(Duration duration, UUID controller) {
        super(duration, Layer.ControlChangingEffects_2, SubLayer.NA, Outcome.GainControl);
        this.controller = controller;
        this.staticText = "That player gains control of {this}";
    }

    private GoblinFestivalGainControlEffect(GoblinFestivalGainControlEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.controller = effect.controller;
    }

    public GoblinFestivalGainControlEffect copy() {
        return new GoblinFestivalGainControlEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent != null) {
            return permanent.changeControllerId(this.controller, game, source);
        }
        return false;
    }
}

