/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GoblinGuideEffect
extends OneShotEffect {
    GoblinGuideEffect() {
        super(Outcome.DrawCard);
    }

    private GoblinGuideEffect(GoblinGuideEffect effect) {
        super((OneShotEffect)effect);
    }

    public GoblinGuideEffect copy() {
        return new GoblinGuideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player defender = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null && defender != null) {
            Card card = defender.getLibrary().getFromTop(game);
            if (card != null) {
                CardsImpl cards = new CardsImpl(card);
                defender.revealCards(sourceObject.getName(), (Cards)cards, game);
                if (card.isLand(game)) {
                    defender.moveCards(card, Zone.HAND, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

