/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GoblinGuideTriggeredAbility
extends TriggeredAbilityImpl {
    protected String text;

    public GoblinGuideTriggeredAbility(Effect effect, boolean optional) {
        super(Zone.BATTLEFIELD, effect, optional);
    }

    public GoblinGuideTriggeredAbility(Effect effect, boolean optional, String text) {
        super(Zone.BATTLEFIELD, effect, optional);
        this.text = text;
    }

    private GoblinGuideTriggeredAbility(GoblinGuideTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
        this.text = ability.text;
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        UUID defenderId;
        if (event.getSourceId().equals(this.getSourceId()) && (defenderId = game.getCombat().getDefendingPlayerId(this.getSourceId(), game)) != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(defenderId, game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever {this} attacks, defending player reveals the top card of their library. If it's a land card, that player puts it into their hand.";
    }

    public GoblinGuideTriggeredAbility copy() {
        return new GoblinGuideTriggeredAbility(this);
    }
}

